# BeautifulSoup

查找网页里所有图片地址

```python
from bs4 import BeautifulSoup

def fetch_imgs(html):
    # TODO(You): 请在此实现代码
    return imgs

def test():
    imgs = fetch_imgs(
        '<p><img src="http://example.com"/><img src="http://example.com"/></p>')
    print(imgs)

if __name__ == '__main__':
    test()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
from bs4 import BeautifulSoup


def fetch_imgs(html):
    soup = BeautifulSoup(html, 'html.parser')
    imgs = [tag['src'] for tag in soup.find_all('img')]
    return imgs


def test():
    imgs = fetch_imgs(
        '<p><img src="http://example.com"/><img src="http://example.com"/></p>')
    print(imgs)

if __name__ == '__main__':
    test()
```

## 答案

```python
def fetch_imgs(html):
    soup = BeautifulSoup(html, 'html.parser')
    imgs = [tag['src'] for tag in soup.find_all('img')]
    return imgs
```

## 选项

### A

```python
def fetch_imgs(html):
    soup = BeautifulSoup(html, 'html.parser')
    imgs = [tag for tag in soup.find_all('img')]
    return imgs
```

### B

```python
def fetch_imgs(html):
    soup = BeautifulSoup(html, 'html.parser')
    imgs = soup.find_all('img')
    return imgs
```

### C

```python
def fetch_imgs(html):
    soup = BeautifulSoup('html.parser', html)
    imgs = [tag['src'] for tag in soup.find_all('img')]
    return imgs
```
